class VirtualDomainPage < Page
  def find_by_url(url, live = true, clean = true)
    page = child_for_host || children.find(:first, :conditions => ["status_id = ?", Status[:published].id])
    page.find_by_url url, live, clean
  end

  # child_url is / (root) because child is determined by hostname not url
  def child_url(child)
    '/'
  end

  # hostname from http request
  def hostname
    @hostname ||= Page.request.respond_to?(:host) ? Page.request.host : nil
  end

  private

    # child page for corresponding hostname (from config)
    def child_for_host(hostname = self.hostname)
      @host_child ||= children.find_by_slug(slug_for_host(hostname))
    end

    # slug that corresponds to hostname (from config)
    def slug_for_host(hostname = self.hostname)

      # find returns key-value pair, need slug (which is last element)
      pair = site_map.find { |host, slug| /#{Regexp.escape host}/ =~ hostname }
      if pair
        pair.last
      else
        site_map["*"] || ""
      end
    end

    def site_map
      unless @site_map ||= config and !@site_map.empty?
        @site_map = children.inject({}) do |memo, page|
          memo[page.slug] = page.slug
          memo
        end
      end
      @site_map
    end
end
